<?php $__env->startSection('content'); ?>

    <div class="row g-4">
        <div class="col-xl-3 col-sm-6">
            <div class="dashboard__card card">
                <img class="dc__img" src="<?php echo e(getImage($activeTemplateTrue . 'images/star-outline.png')); ?>"
                    alt="<?php echo app('translator')->get('Image'); ?>">
                <div class="dc__account">
                    <span><i class="fa-solid fa-blog"></i></span>
                    <div class="dc__account__content">
                        <h4><?php echo app('translator')->get('Total Posts'); ?></h4>
                        <p><?php echo e($widget['total_post']); ?> <?php echo app('translator')->get('Posts'); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="dashboard__card card">
                <img class="dc__img" src="<?php echo e(getImage($activeTemplateTrue . 'images/star-outline.png')); ?>"
                    alt="<?php echo app('translator')->get('Image'); ?>">
                <div class="dc__account">
                    <span><i class="fa-solid fa-clock"></i></span>
                    <div class="dc__account__content">
                        <h4><?php echo app('translator')->get('Scheduled Posts'); ?></h4>
                        <p><?php echo e($widget['total_schedule_post']); ?> <?php echo app('translator')->get('Posts'); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="dashboard__card card">
                <img class="dc__img" src="<?php echo e(getImage($activeTemplateTrue . 'images/star-outline.png')); ?>"
                    alt="<?php echo app('translator')->get('Image'); ?>">
                <div class="dc__account">
                    <span><i class="fa-solid fa-clipboard-list"></i></span>
                    <div class="dc__account__content">
                        <h4><?php echo app('translator')->get('Draft Posts'); ?></h4>
                        <p><?php echo e($widget['draft_post']); ?> <?php echo app('translator')->get('Posts'); ?></p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-sm-6">
            <div class="dashboard__card card">
                <img class="dc__img" src="<?php echo e(getImage($activeTemplateTrue . 'images/star-outline.png')); ?>"
                    alt="<?php echo app('translator')->get('Image'); ?>">
                <div class="dc__account">
                    <span><i class="fa-solid fa-upload"></i></span>
                    <div class="dc__account__content">
                        <h4><?php echo app('translator')->get('Publish Posts'); ?></h4>
                        <p><?php echo e($widget['publish_post']); ?> <?php echo app('translator')->get('Posts'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 pt-4">
        <div class="col-lg-7">
            <div class="card">
                <div class="chart__topbar">
                    <h5><?php echo app('translator')->get('Total Posts by Platform'); ?></h5>
                </div>
                <div class="row g-2">
                    <div class="col-xl-4 col-sm-6">
                        <div class="post__statistics">
                            <h4><?php echo e($widget['facebook']); ?></h4>
                            <p><?php echo app('translator')->get('Facebook Post'); ?></p>
                            <a href="<?php echo e(route('user.posts.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                        </div>
                    </div>
                    <div class="col-xl-4 col-sm-6">
                        <div class="post__statistics">
                            <h4><?php echo e($widget['instagram']); ?></h4>
                            <p><?php echo app('translator')->get('Instagram Post'); ?></p>
                            <a href="<?php echo e(route('user.posts.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                        </div>
                    </div>
                    <div class="col-xl-4 col-sm-6">
                        <div class="post__statistics">
                            <h4><?php echo e($widget['twitter']); ?></h4>
                            <p><?php echo app('translator')->get('Twitter Post'); ?></p>
                            <a href="<?php echo e(route('user.posts.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                        </div>
                    </div>
                    <div class="col-xl-4 col-sm-6">
                        <div class="post__statistics">
                            <h4><?php echo e($widget['linkedin']); ?></h4>
                            <p><?php echo app('translator')->get('Linkedin Post'); ?></p>
                            <a href="<?php echo e(route('user.posts.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                        </div>
                    </div>
                    <div class="col-xl-4 col-sm-6">
                        <div class="post__statistics">
                            <h4><?php echo e($widget['tiktok']); ?></h4>
                            <p><?php echo app('translator')->get('Tiktok Post'); ?></p>
                            <a href="<?php echo e(route('user.posts.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                        </div>
                    </div>
                    <div class="col-xl-4 col-sm-6">
                        <div class="post__statistics">
                            <h4><?php echo e($widget['youtube']); ?></h4>
                            <p><?php echo app('translator')->get('Youtube Post'); ?></p>
                            <a href="<?php echo e(route('user.posts.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="card">
                <div class="chart__topbar">
                    <h5><?php echo app('translator')->get('Published Posts by Platform'); ?></h5>
                </div>
                <div class="post__by__platform">
                    <div id="post__statistics__chart"></div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-lg-12">
            <div class="card">
                <div class="dh__title">
                    <h5><?php echo app('translator')->get('Recent Post'); ?></h5>
                </div>
                <div class="dashboard__table">
                    <table class="table table--responsive--lg">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('S.L'); ?></th>
                                <th><?php echo app('translator')->get('Account'); ?></th>
                                <th><?php echo app('translator')->get('Title'); ?></th>
                                <th><?php echo app('translator')->get('Schedule'); ?></th>
                                <th><?php echo app('translator')->get('Created At'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $recentPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loop => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>

                                    <td>
                                        <div class="d-flex gap-2 align-items-center">
                                            <div class="dc__account__img">
                                                <img class="fit--img"
                                                    src="<?php echo e(getImage(getFilePath('platform') . '/' . $post->socialAccount->platform->image, getFileSize('platform'))); ?>"
                                                    alt="image">
                                                <img class="fit--img dc__platfrom"
                                                    src="<?php echo e($post->socialAccount->profile_image != null ? $post->socialAccount->profile_image : getImage('assets/images/general/avatar.png')); ?>"
                                                    alt="">
                                            </div>
                                            <div class="table__plt">
                                                <h4><?php echo e($post->socialAccount->profile_name); ?></h4>
                                                <p><?php echo e($post?->socialAccount?->platform?->name ?? ''); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e(strLimit(__($post->title), 10)); ?></td>

                                    <td><?php echo $post->scheduleStatusBadge; ?>
                                        <?php if($post->is_schedule): ?>
                                            <br>
                                            <?php echo e(showDateTime($post->schedule_datetime, 'd M Y, H:i:A')); ?>

                                        <?php endif; ?>
                                    </td>

                                    <td><?php echo e(showDateTime($post->created_at, 'd M Y, H:i:A')); ?></td>

                                    <td><?php echo $post->statusBadge; ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/apexcharts.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            'use strict';
            if ($('#post__statistics__chart').length) {
                var options = {
                    series: <?php echo json_encode($series); ?>,
                    chart: {
                        type: 'donut',
                        width: "100%",
                    },
                    labels: <?php echo json_encode($labels); ?>,
                    colors: ['#1D4ED8', '#0EA5E9', '#F43F5E', '#10B981', '#F59E0B'],
                    legend: {
                        position: 'bottom',
                    },
                    dataLabels: {
                        enabled: true,
                        formatter: function (val) {
                            return val.toFixed(1) + "%";
                        }
                    }
                };

                var chart = new ApexCharts(document.querySelector("#post__statistics__chart"), options);
                chart.render();
            }
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('Template::layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\quickpost\application\resources\views/presets/default/user/dashboard.blade.php ENDPATH**/ ?>